//+------------------------------------------------------------------+
//|                                              StochasticArrow.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   2

//--- plot ArrowUp
#property indicator_label1  "ArrowUp"
#property indicator_type1   DRAW_ARROW
#property indicator_color1  clrLime
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

//--- plot ArrowDown
#property indicator_label2  "ArrowDown"
#property indicator_type2   DRAW_ARROW
#property indicator_color2  clrRed
#property indicator_style2  STYLE_SOLID
#property indicator_width2  2

//--- indicator buffers
double         ArrowUpBuffer[];
double         ArrowDownBuffer[];

//--- Inputs
input int   k_input           = 5;                          //%K
input int   d_input           = 3;                          //%D
input int   slow_input        = 3;                          //Slowing
input       ENUM_MA_METHOD ma_method_input = MODE_SMA;      //Method
input       ENUM_STO_PRICE sto_price_input = STO_LOWHIGH;   //Price Field

//--- stochastic handle
int stochastic_handle;
double       MainBuffer[];
double       SignalBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,ArrowUpBuffer,INDICATOR_DATA); ArraySetAsSeries(ArrowUpBuffer,true);
   SetIndexBuffer(1,ArrowDownBuffer,INDICATOR_DATA); ArraySetAsSeries(ArrowDownBuffer,true);

//--- setting a code from the Wingdings charset as the property of PLOT_ARROW
   PlotIndexSetInteger(0,PLOT_ARROW,233);
   PlotIndexSetInteger(1,PLOT_ARROW,234);

//--- get stochastic handle
   stochastic_handle = iStochastic(_Symbol,PERIOD_CURRENT,k_input,d_input,slow_input,ma_method_input,sto_price_input);

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   int limit = rates_total - prev_calculated;
   //--- counting from 0 to rates_total
   ArraySetAsSeries(ArrowUpBuffer, true);
   ArraySetAsSeries(ArrowDownBuffer, true);
   //--- initial zero
   if(prev_calculated < 1)
     {
      ArrayInitialize(ArrowUpBuffer, EMPTY_VALUE);
      ArrayInitialize(ArrowDownBuffer, EMPTY_VALUE);
     }
   else
      limit++;

   for(int i = limit-2; i >= 0; i--)
     {
      ArraySetAsSeries(low,true);
      ArraySetAsSeries(high,true);
      CopyBuffer(stochastic_handle,0,i,3,MainBuffer); ArraySetAsSeries(MainBuffer,true);
      CopyBuffer(stochastic_handle,1,i,3,SignalBuffer); ArraySetAsSeries(SignalBuffer,true);

      if(MainBuffer[2]<SignalBuffer[2]&&MainBuffer[1]>SignalBuffer[1])
      {
         ArrowUpBuffer[i+1] = iLow(_Symbol,PERIOD_CURRENT,i+1) - 70 *_Point;

         // Trigger alerts for Buy signal
         string message = "SCO Buy";
         Alert(message);
         SendNotification(message);
      }
      else
        {
         ArrowUpBuffer[i] = EMPTY_VALUE;
        }

      if(MainBuffer[2]>SignalBuffer[2]&&MainBuffer[1]<SignalBuffer[1])
      {
         ArrowDownBuffer[i+1] = iHigh(_Symbol,PERIOD_CURRENT,i+1) + 70 * _Point;

         // Trigger alerts for Sell signal
         string message = "SCO Sell";
         Alert(message);
         SendNotification(message);
      }
      else
        {
         ArrowDownBuffer[i] = EMPTY_VALUE;
        } 
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
